--------------------------------------------------------------------
--            SymCACP Search Module 1         Golly bits chaos
-- Symmetrical CA Control Panel   symCACPsrch
-- End is determined when the population is very small - not chaos
-- or when the maximum length diaganol pair of lines of the same state
-- can reasonable be classed as part of chaos.
-- This length will be deteremed elswhere.
---------------------------------------------------------------------
--  P. Rendell   12/10/2018
--------------------------------------------------------------------
--------------------------------------------------------------------
local m ={}		-- class main
m.result = ''
local g = golly()
local gr = require("buildUni") 

--------------------------------------------------------------------------------
function bool2txt(b)
   if b then
      return 'true'
   end
   return 'false'
end
--------------------------------------------------------------------------------
local function strCC(s1,s2)
   local res = ''
   if  s2 then
      if s1 then
         res = s1..s2
      else
         res = '**NIL**'..s2
      end
   elseif s1 then
      res = s1..'**NIL**'
   else
      res = '**NIL*NIL**'
   end
   return res
end

--------------------------------------------------------------------
   function EmtpyPT()
      return({x = 0, y = 0, len = 0, cnt = 0, yDec = true })
   end
--------------------------------------------------------------------
-- init Function

   function m.init(logFile)
      m.logFile = logFile
      m.logFile:write("search-chaos:Got Log File\n")
   end
--==================================================================
--------------------------------------------------------------------
--------------------------------------------------------------------
   function universeSave()
      local s = {}
      s.result = 'none'
      s.pt = EmtpyPT()
      s.restore =   function()
                       g.select({0,0,1,1})
      		       g.clear(1)
      		       g.clear(0)
      		       g.select({})
                       g.putcells(s.universe)
                       g.setgen(s.gen)
                    end
      s.setResult = function (res)
                       s.result = res
                       if res == 'killed' then
                          m.result = 'killed'
                       end
                    end
      s.getChanges =  function(o)	-- return the number of cells which have different states in uni s and uni o
                    end        
      s.gen = tonumber(g.getgen())
      s.pop = tonumber(g.getpop())
      s.pop = math.min(s.pop, m.maxCells - s.pop)
      s.universe = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
      return s
   end
--------------------------------------------------------------------
--------------------------------------------------------------------
   function m.isCurrentUni(uni)   
      local newPat = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
      local found = false
      if #newPat == #uni.universe then
         found = true
         for j = 1, #newPat do
            if newPat[j] ~= uni.universe[j] then
               found = false
               break
            end
         end
      end
      return found   
   end
--------------------------------------------------------------------

   function m.getUniOsc()
      local event
      local uni = universeSave()
      if m.oscPeriod > 0 then
          g.run(m.oscPeriod)
	  if m.isCurrentUni(uni) then
	     uni.setResult('osc')
	  end
         uni.restore()
      else
         local pop = g.getpop()
         if (m.oscLengMin>1) then 
            g.run(m.oscLengMin-1)
         end
         for i = 1, (1+m.oscLengMax-m.oscLengMin)*2+1 do
            g.run(1)
            event = g.getevent()
            if (event:find("^key") or event:find("^oclick"))  then
               m.logFile:write("getUniOsc stoped by user action gen "..uni.gen.."\n")
               uni.setResult("killed")
               m.keepGoing = false
               break
            end
            if (pop == g.getpop()) and m.isCurrentUni(uni) then
	        uni.setResult('osc')
	        m.oscPeriod = i+m.oscLengMin-1
	        break
	    end
         end
         uni.restore()
      end
--      m.logFile:write("getUniOsc gen "..uni.gen.." oscLeng "..m.oscLengMin..","..m.oscLengMax.." oscPeriod "..m.oscPeriod.."\n")
      return uni
   end
--------------------------------------------------------------------
-- Simpler version without complex population checks which will work with oscLengMin>1
-- problem we have is accomoding chaos for D and O if we change to know
-- do we need an endgame section?  could look both diag and orth store in uni and keep
-- looking

   function m.getUniChaos(oldPT)
      local event
      local uni = universeSave()
      local x,y
   
      function incI(x)
         local nx = x+1
         if (nx > m.width//2 - 1) then
               nx = -(m.width//2)
         end
         return(nx)
      end
      
      function decI(y)
         local ny = y-1
         if (ny < -(m.hight//2)) then
            ny = m.hight//2 -1
         end
         return(ny)
      end
      
      function chaosFound(pt)
         return( (pt.len > 0) and (pt.len < m.minRunLength) and (pt.cnt > m.minPTcnt) )
      end
      
      function checkOldPT(oldPT)
         local ok = (not chaosFound(oldPT)) and (oldPT.len ~= 0)
         local x = oldPT.x
         local y = oldPT.y
         local state = g.getcell(x, y)
         local delta = 1
         while(ok and (delta + 1) < oldPT.len) do
            delta = delta + 1
            x = incI(x)
            if (oldPT.yDec) then
               y = decI(y)
            end
            ok = (state == g.getcell(x, y))
         end
         return(ok)
      end
      
      function findLongRunCentre(yDec)
         local pt = EmtpyPT()
         local x,y,len,x0,y0
         pt.yDec = yDec
         for i = -(m.width//2), (m.width-1)//2 do         
            x = i
            y = 0
            x0 = x;y0 = y
            len = 1
            state = g.getcell(x,y)
            for n = 1, m.width do
               x = incI(x)
               if (yDec) then
                  y = decI(y)
               end
               if ( (state == g.getcell(x,y)) and ( (not yDec) or (state == g.getcell(incI(x),y))) ) then
                  len = len +1
               else
                  if (len > pt.len) then
                     m.logFile:write("run break "..x0..","..y0.." : "..x..","..y.." len "..len.."\n")
                     pt.x = x
                     pt.y = y
                     pt.len = len
                     pt.cnt = 1
                  elseif (len == pt.len) then
                     pt.cnt = pt.cnt+1
                  end
                  x0 = x;y0 = y
                  state = g.getcell(x,y)
                  len = 1
                  if ((m.width - n) < pt.len) then
                     break
                  end
               end
            end
            if (len > pt.len) then
               m.logFile:write("run break "..x0..","..y0.." : "..x..","..y.." len "..len.."\n")
	       pt.x = x
	       pt.y = y
	       pt.len = len
	       pt.cnt = 1
	   end
         end
         g.update()
         return(pt)
      end
      
      if(uni.pop < m.minCellEmpty) then
         uni.setResult('osc')
      else
         if (checkOldPT(oldPT)) then
            uni.pt = oldPT
            m.logFile:write("getUniChaos gen "..uni.gen.." Old pt is still the same\n")
         else
            uni.pt.x = -99
            uni.pt.y=-99
            uni.pt.len=-99
            uni.pt.yDec = oldPT.yDec
            uni.pt = findLongRunCentre(uni.pt.yDec)
            if (chaosFound(uni.pt)) then
               local otherPT = uni.pt
               uni.pt = findLongRunCentre(not uni.pt.yDec)
               if (chaosFound(uni.pt)) then
                  uni.setResult('chaos')
               else
                  if (otherPT.len > uni.pt.len) then
                     uni.pt.len =  otherPT.len
                  end
               end
            end
         end
      end
      m.logFile:write("getUniChaos gen "..uni.gen.." pt x "..uni.pt.x.." y "..uni.pt.y.." uni.pt.len "..uni.pt.len.." uni.pt.cnt "..uni.pt.cnt.." result "..uni.result.."\n")
      m.logFile:flush()
      return uni
   end
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------
   function m.loopForOscEnd(step1)
      -- First loop to determine if the end is reachable by looking for oscillation based on population count
      -- follow up by checking matching patterns
      local thisStep = math.floor(step1)
      local firstStep = true
      local universeBefore, universeAfter
      local event
      local getOsc = false
      
      m.oscPeriod = -1
--      m.logFile:write("loopForOscEnd started 1 step1 "..step1.."\n")
      m.keepGoing = true

      universeBefore = m.getUniChaos(EmtpyPT()) 
      m.logFile:write("loopForOscEnd started 2 step1 "..step1.."\n")
      universeAfter = universeBefore
      m.keepGoing = (universeBefore.result ~= 'osc') and (universeBefore.result ~= 'chaos') 
          
      while m.keepGoing do 
         g.run(thisStep)
         if (getOsc) then 
            universeAfter = m.getUniOsc()
         else
            universeAfter = m.getUniChaos(universeBefore.pt) 
         end
         if ((universeAfter.result == 'osc') or (universeAfter.result == 'chaos'))  then
            getOsc = getOsc or (universeAfter.result == 'osc')
            if thisStep > 1 then
               thisStep = math.max(1, (thisStep+1)//2 )
               m.logFile:write("loopForOscEnd backward thisStep "..thisStep.." gen "..universeBefore.gen.." max ".. m.maxGen.."\n")
               universeAfter = universeBefore
               universeAfter.restore()
               firstStep = false
            else							-- universeAfter is lowest osc universe
               --universeAfter.setResult('end')
               m.keepGoing = false
            end
         else				-- no oscilation found
            if (universeAfter.gen < m.maxGen) then
               thisStep = math.max(2,thisStep + thisStep//2)
               m.logFile:write("loopForOscEnd forward thisStep "..thisStep.." gen "..universeBefore.gen.." max ".. m.maxGen.."\n")
            else
               universeAfter.setResult("maxEx")
               m.keepGoing = false
               m.logFile:write("max exceeded finished gen "..universeAfter.gen.." max ".. m.maxGen.."\n")
            end
         end
         g.show("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.maxGen.." oscPeriod "..m.oscPeriod.." maxCells "..m.maxCells)
         m.logFile:write("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.maxGen.." oscPeriod "..m.oscPeriod.." maxCells "..m.maxCells..' kg '..bool2txt(m.keepGoing)..'\n')
         if m.keepGoing then
            event = g.getevent()
            if (event:find("^key") or event:find("^oclick")) then
               m.logFile:write("loopForOscEnd stoped by user action gen "..universeAfter.gen.." max gen ".. m.maxGen.."\n")
               universeAfter.setResult("killed")
               m.keepGoing = false
            end
         end
         universeBefore = universeAfter
      end
      m.oscPopList = nil
      universeBefore.restore()
      return universeAfter
   end
--------------------------------------------------------------------
--------------------------------------------------------------------

function m.doFindEnd(seed, maxGen, step1, oscLenMin, oscLenMax)  -- called from SymCACP or SymCACPscript
   m.seed = seed
   m.width = tonumber(g.getwidth())
   m.hight = tonumber(g.getheight())
   g.setbase(32)    
   m.maxCells = m.width * m.hight
   m.minCellEmpty = math.max(20,m.maxCells//10)
   m.minRunLength = 8
   m.minPTcnt = 0  --- math.max(2,m.width/10)
   m.maxGen = maxGen
   m.result = 'none'
   m.pop = -1
   m.oscLengMin = 1
   m.oscLengMax = 100
   m.logFile:write('initFind ('..seed..strCC(',',tostring(maxGen))..strCC(',',tostring(oscLengMax))
                               ..strCC(')->(',tostring(m.maxGen))..strCC(',',tostring(m.oscLengMax))
                               ..' minPTcnt='..m.minPTcnt..' minRunLength='..m.minRunLength..' minCellEmpty='..m.minCellEmpty
                               ..')\n')
   if oscLenMin then m.oscLengMin = oscLenMin end
   if oscLenMax then m.oscLengMax = oscLenMax end
   
   local Urule = g.getrule()
   if Urule:find(':') then
      local hexRule = Urule:sub(1,Urule:find(':')-1)
      m.logFile:write("FindEnd starting "..hexRule.."\n")
      if Urule:find('HEX') then
         hexRule = hexRule:gsub('HEX','H')
      else
         hexRule = gr.convBS2Hex(hexRule)
      end
      local uni = m.loopForOscEnd(step1)
      g.update()
      g.show("Finished "..uni.result.." "..hexRule.." "..seed.." "..m.width..","..m.hight.." gen "..uni.gen..' Osc '..m.oscPeriod)
      m.logFile:write("FindEnd finished "..uni.result.." "..hexRule.." "..seed.." "..m.width..","..m.hight.." gen "..uni.gen..' Osc '..m.oscPeriod..' oscLen '..m.oscLengMax.."\n")
      m.logFile:flush()
      m.pop = uni.pop
      if m.result == 'killed' then
         return 'killed'
      else
         return uni.result         
      end
   else
      g.show('** not a torus universe **')
      return 'Not Totus'
   end
end
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------

return m

--------------------------------------------------------------------
--                      	END OF FILE
--------------------------------------------------------------------
